/*
	Stempora Web Framework
	Copyright (c) 2002-2018 Stempora. 
	All rights reserved.
		web:  www.stempora.com
		mail: support@stempora.com				
*/

var STBGlobalMW = Object.create(STBModule.prototype);

STBGlobalMW.name = "Global Module & Widget HTML Fix";

STBGlobalMW.fixModule = function() {
	var module = jQuery(".module");

	if (module.length > 0) {
		var moduleHeadTitle = module.find(".module-head .title"),
			moduleHeader = module.find(".module-header"),
			moduleFooter = module.find(".module-footer");

		if (moduleHeadTitle.length > 0) {

			var parseTitle = function () {
				var obj = jQuery(this),
					parent = obj.parent();

				if (obj.text().trim() == "") {
					if (parent.find(".options").length == 0) {
						parent.remove();
					}
				}
			};

			moduleHeadTitle.each(parseTitle);
		}


		if (moduleHeader.length > 0) {
			var parseHeader = function () {
				var obj = jQuery(this);

				if (obj.has("*").length > 0) {
				} else {
					if (obj.text().trim() == "") {
						obj.remove();
					}
				}
			};

			moduleHeader.each(parseHeader);
		}


		if (moduleFooter.length > 0) {
			var parseFooter = function () {
				var obj = jQuery(this);

				if (obj.html().trim() == "") {
					obj.remove();
				}
			};

			moduleFooter.each(parseFooter);
		}
	}
}

STBGlobalMW.fixWidget = function() {
	var widget = jQuery('.widget');

	if (widget.length > 0) {
		var widgetHeader = widget.find('.widget-header'),
			widgetTitle = widget.find('.widget-head .title');

		if (widgetHeader.length > 0) {
			var parseWgHeader = function () {
				var obj = jQuery(this);

				if (obj.text().trim() == "") {
					obj.remove();
				}
			};

			widgetHeader.each(parseWgHeader);
		}

/*
		if (widgetTitle.length > 0) {
			var parseWgTitle = function () {
				var obj = jQuery(this);

				if (obj.text().trim() == "") {
					obj.parent().remove();
				}
			};

			widgetTitle.each(parseWgTitle);
		}
*/
	}
}

STBGlobalMW.fixMargins = function() {
	//fix the margin bottom
	jQuery(".module-body > *:last-child , .widget-body >*:last-child, .widget-body > .row > .isotope-element:last-child").not(".widget").each(function() {

		var el = jQuery(this),
			margin = jQuery(this).css("margin-bottom");

		if (el.hasClass("isotope-container") || el.hasClass("same-height")) {
			var st = jQuery(this).find(" > *:last-child");

			if (st.length) {
				margin = st.css("margin-bottom");
			}
		}

		parent = jQuery(this).parent();
		parent.css("margin-bottom" , "-" + margin);
	});

}



STBGlobalMW.setElementPadding = function(el, op) {
    try {
        var exist = op.length,
            px = op.outerWidth();

        if (el.length > 0) {
            if (jQuery("html").attr("dir") == "rtl") {
                el.css('padding-left', (exist > 0 ? px + 10 : 0));
            } else {
                el.css('padding-right', (exist > 0 ? px + 10 : 0));
            }
        }

    } catch (e) {
        getStack(0, e);
    }
}

STBGlobalMW.initPaddings = function () {
    try {
        var $moduleHead = jQuery('.module-head:not(.__done)'),
            $sortBar = jQuery('.sort-bar'),
            $commentAuthor = jQuery('.comment', '.comments').find('.comment-author'),
            $checkoutStep = jQuery('.checkout-step'),
            $checkoutHead = $checkoutStep.find('.checkout-head'),
            $checkoutAccTitle = jQuery('.accordion.accordion-payment .panel-title'),
            $checkoutLink = $checkoutAccTitle.find('a'),
            $checkoutLabel = jQuery('.checkout-step .checkout-body .form .form-item.form-item-radio > .form-item-radio-element > label'),
            $checkoutParent = $checkoutLabel.find('.parent'),
            $authorSocial = jQuery('.author-social');

        if ($authorSocial.length > 0) {
            var parseMoreTopics = function () {
                var obj = jQuery(this),
                    moreTopics = obj.next('.more-topics');

                STBGlobalMW.setElementPadding(obj, moreTopics);
            };

            $authorSocial.each(parseMoreTopics);
        }

        if ($moduleHead.length > 0) {
            var parseModule = function () {
                var obj = jQuery(this),
                    title = obj.find('.title'),
                    options = obj.find('.options');

                STBGlobalMW.setElementPadding(title, options);

				obj.addClass("__done");
            };

            $moduleHead.each(parseModule);
        }

        if ($sortBar.length > 0) {
            var parseBar = function () {
                var obj = jQuery(this),
                    rightSide = obj.find('.right-side');

                STBGlobalMW.setElementPadding(obj, rightSide);
            };

            $sortBar.each(parseBar);
        }

        if ($commentAuthor.length > 0) {
            var parseComment = function () {
                var obj = jQuery(this),
                    reply = obj.find('.comment-reply');

                STBGlobalMW.setElementPadding(obj, reply);
            };

            $commentAuthor.each(parseComment);
        }

        if ($checkoutHead.length > 0) {
            var parseCheck = function () {
                var obj = jQuery(this),
                    options = obj.find('.options');

                STBGlobalMW.setElementPadding(obj, options);
            };

            $checkoutHead.each(parseCheck);
        }

        if ($checkoutLink.length > 0) {
            var parseAccordionTitle = function () {
                var obj = jQuery(this),
                    options = obj.find('ul');

                STBGlobalMW.setElementPadding(obj, options);
            };

            $checkoutLink.each(parseAccordionTitle);
        }

        if ($checkoutParent.length > 0) {
            var parseOffer = function () {
                var obj = jQuery(this),
                    options = obj.find('span[type="offer"]');

                STBGlobalMW.setElementPadding(obj, options);
            };

            $checkoutParent.each(parseOffer);
        }

    } catch (e) {
        getStack(0, e);
    }
}

STBGlobalMW.resetModule = function() {
	jQuery(".module-head").removeClass("__done");
}

STBGlobalMW.runOnContentUpdate = function() {
	STBGlobalMW.fixWidget();
	STBGlobalMW.fixModule();
	STBGlobalMW.fixMargins();
	STBGlobalMW.initPaddings();
}

STBGlobalMW.runOnReady = function () {
	STBGlobalMW.fixWidget();
	STBGlobalMW.fixModule();
	STBGlobalMW.fixMargins();
}

STBGlobalMW.runOnLoad = function() {
	STBGlobalMW.initPaddings();
}

STBGlobalMW.runOnResize = function() {
	STBGlobalMW.resetModule();
	STBGlobalMW.initPaddings();
}


site.registerModule(STBGlobalMW);